<?php
namespace Newland\Toubiz\Events\Neos;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Core\Bootstrap;
use Neos\Flow\Package\Package as BasePackage;
use Newland\Toubiz\Events\Neos\Listener\BuildUrls;
use Newland\Toubiz\Sync\Neos\Command\EventsCommandController;

class Package extends BasePackage
{
    public function boot(Bootstrap $bootstrap)
    {

        $dispatcher = $bootstrap->getSignalSlotDispatcher();

        $dispatcher->connect(
            EventsCommandController::class,
            'flush',
            BuildUrls::class,
            'run'
        );
    }
}
