<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\Migration\Transformations;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeData;
use Neos\ContentRepository\Migration\Transformations\AbstractTransformation;

class RegionsToPreselectedRegions extends AbstractTransformation
{
    public function execute(NodeData $node): NodeData
    {
        if ($node->hasProperty('regions')) {
            $node->setProperty('preselectedRegions', $node->getProperty('regions'));
        }

        return $node;
    }
}
