<?php

namespace Newland\Toubiz\Events\Neos\DataSource;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Query;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\NeosCommon\Translation\LanguageAwareDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * @Flow\Scope("singleton")
 */
class OrganizersDataSource extends AbstractDataSource
{
    use LanguageAwareDataSource;

    /**
     * Data source identifier.
     *
     * @var string
     */
    protected static $identifier = 'newland-toubiz-events-neos-organizers';

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * @var EventRepository
     * @Flow\Inject()
     */
    protected $eventRepository;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        $this->eventRepository->setLanguage($this->getLanguage($node));

        return $this->eventRepository->createQueryBuilder('event')
            ->select(
                [
                    'organizer.Persistence_Object_Identifier AS value',
                    'organizer.name AS label',
                ]
            )
            ->distinct(true)
            ->innerJoin('event.organizer', 'organizer')
            ->orderBy('organizer.name')
            ->getQuery()
            ->execute(null, Query::HYDRATE_ARRAY);
    }
}
