<?php declare(strict_types=1);
namespace Newland\Toubiz\Events\Neos\Filter;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\ObjectManagement\Exception\InvalidObjectException;
use Newland\NeosFiltering\Factory\DefaultFilterFactory;
use Newland\Toubiz\Events\Neos\Filter\Items\Date;
use Newland\Toubiz\Events\Neos\Filter\Items\EventDateRoot;
use Newland\Toubiz\Events\Neos\Filter\Items\EventHighlight;
use Newland\Toubiz\Events\Neos\Filter\Items\EventScope;
use Newland\Toubiz\Events\Neos\Filter\Items\EventType;
use Neos\Flow\Annotations as Flow;

class EventDateFilterFactory extends DefaultFilterFactory
{
    protected $optionalSetters = [
        'setState' => 'defaultState',
        'setQueryStrings' => 'queryStringMultiple',
        'setDatabaseColumns' => 'databaseColumns',
    ];

    /**
     * @var array
     * @Flow\InjectConfiguration(path="filter")
     */
    protected $filterSettings;

    public function __construct(NodeInterface $node)
    {
        parent::__construct($node);
        $this->predefinedTypes['event_type'] = EventType::class;
        $this->predefinedTypes['event_scope'] = EventScope::class;
        $this->predefinedTypes['date'] = Date::class;
        $this->predefinedTypes['filter_highlights'] = EventHighlight::class;
    }

    public function setFilterSettings(array $filterSettings): self
    {
        $this->filterSettings = $filterSettings;
        return $this;
    }

    public function createEventFilter(
        array $eventTypes = [],
        array $overrides = [],
        string $context = 'frontend'
    ): EventDateRoot {
        $filter = $this->createFilter($this->filterSettings, $overrides, $context);
        if (!($filter instanceof EventDateRoot)) {
            throw new InvalidObjectException('Object is expected to be EventDateRoot');
        }
        $filter->setEventTypes($eventTypes);

        return $filter;
    }

    protected function getRootClassName(): string
    {
        return EventDateRoot::class;
    }
}
