<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Newland\NeosTestingHelpers\CompilesFusion;

class StandaloneTeaserTest extends IntegrationTestCase
{
    use CompilesFusion;

    public function testTeaserCanBeRenderedStandalone(): void
    {
        $title = uniqid('EVENT_TITLE_', true);
        [ $event ] = $this->createEventWithDate([ 'title' => $title ], [ 'beginsAt' => '2030-01-01T15:22', 'endsAt' => '2030-01-01T18:22' ]);

        $result = $this->compileFusion(
            $this->siteNode,
            sprintf('Newland.Toubiz.Events.Neos:Teaser {
                    properties = Neos.Fusion:DataStructure {
                        event = "%s"
                    }
                }', $event->getPersistenceObjectIdentifier()),
            [ 'documentNode' => $this->documentNode ]
        );

        $this->assertStringContainsString($title, $result);
    }

    public function testStandaloneTeaserRendersSlots(): void
    {
        [ $event ] = $this->createEventWithDate([ ], [ 'beginsAt' => '2030-01-01T15:22', 'endsAt' => '2030-01-01T18:22' ]);
        $result = $this->compileFusion(
            $this->siteNode,
            sprintf('Newland.Toubiz.Events.Neos:Teaser {
                    properties = Neos.Fusion:DataStructure {
                        event = "%s"
                    }
                }', $event->getPersistenceObjectIdentifier()),
            [ 'documentNode' => $this->documentNode ]
        );

        $this->assertStringContainsString('Slot(belowTitle)', $result);
        $this->assertStringContainsString('Implement prototype(Newland.Toubiz.Events.Neos:Slot.BelowTitle) to display', $result);
    }

}
