<?php
namespace Newland\Toubiz\Events\Neos\Filter\Items;

/*
 * This file is part of the "toubiz-evets-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Query\Expr;
use Newland\Contracts\Neos\Filter\Expression;
use Newland\Contracts\Neos\Filter\FilterItem;
use Newland\Contracts\Neos\Filter\QueryBoundFilterItem;
use Newland\NeosFiltering\Traits\FilterItemCommon;
use Newland\NeosFiltering\Traits\HasCombinationSettings;
use Newland\NeosFiltering\Traits\HasInvisibleState;
use Newland\NeosFiltering\Traits\HasQueryString;
use Newland\NeosFiltering\Traits\NeedsDatabaseColumn;
use Newland\Toubiz\Poi\Neos\Filter\Items\AttributeCommon;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class EventType implements FilterItem, QueryBoundFilterItem
{
    use FilterItemCommon,
        AttributeCommon,
        NeedsDatabaseColumn,
        HasQueryString,
        HasInvisibleState;

    /**
     * Returns a database expression that mirrors the item state.
     * This expression is applied to a database query in order to get the filtered results.
     *
     * Note: The entity that is being filtered for is always aliased as `entity`.
     *
     * @param Expr $expr
     * @return Expression An expression built by the given expression builder.
     */
    public function queryExpression(Expr $expr): Expression
    {
        if (empty($this->state)) {
            return Expression::empty();
        }
        return Expression::where($expr->in($this->databaseColumn, $this->state));
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        $view = $this->initializeView();

        $view->assignMultiple(
            [
                'stateValues' => $this->state,
            ]
        );

        return $view->render('CheckboxListHidden');
    }
}
