<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Newland\Toubiz\Events\Neos\ViewHelpers\Link\AbstractLinkViewHelper;

class TeaserTest extends IntegrationTestCase
{
    public function setUp(): void
    {
        parent::setUp();
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Events.Neos:Teaser'));
        $this->persistNode($this->node);
    }

    public function tearDown(): void
    {
        AbstractLinkViewHelper::pretendToBeInBackendForTest(null);
        parent::tearDown();
    }

    public function testDoesNotThrowError(): void
    {
        $tomorrow = (new \DateTime())->add(new \DateInterval('P1D'));
        $endsAt = (clone $tomorrow)->add(new \DateInterval('PT1H'));
        $event = $this->eventFactory->create([  'beginsAt' => $tomorrow, 'endsAt' => $endsAt, 'title' => 'DATE_TOMORROW' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $tomorrow, 'endsAt' => $endsAt, 'event' => $event ]);

        $this->node->setProperty('event', $event->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
        $this->assertResponseContains('DATE_TOMORROW', $response);
    }

    public function testDoesNotRenderFrontendOutputEventsThatAreInThePast(): void
    {
        $yesterday = (new \DateTime())->sub(new \DateInterval('P1D'));
        $endsAt = (clone $yesterday)->add(new \DateInterval('PT1H'));
        $event = $this->eventFactory->create([  'beginsAt' => $yesterday, 'endsAt' => $endsAt, 'title' => 'DATE_YESTERDAY' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $yesterday, 'endsAt' => $endsAt, 'event' => $event ]);

        $this->node->setProperty('event', $event->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
        $this->assertResponseNotContains('DATE_YESTERDAY', $response);
        $this->assertResponseNotContains('Error: The event has expired', $response);
    }

    public function testRendersSlots(): void
    {
        $tomorrow = (new \DateTimeImmutable())->add(new \DateInterval('P1D'));
        [ $event ] = $this->createEventWithDate([  ], [
            'beginsAt' => $tomorrow,
            'endsAt' => $tomorrow->add(new \DateInterval('PT1H')),
        ]);
        $this->node->setProperty('event', $event->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);

        foreach ($this->provideSlotsThatShouldExist() as [ $slot ]) {
            $this->assertResponseContains(sprintf('Slot(%s)', $slot), $response, null, false);
        }
    }

    public function provideSlotsThatShouldExist(): array
    {
        return [
            [ 'aboveAll' ],
            [ 'belowAll' ],
            [ 'aboveTitle' ],
            [ 'belowTitle' ],
            [ 'aboveStandaloneTeaser' ],
            [ 'belowStandaloneTeaser' ],
            [ 'aboveTeaser' ],
            [ 'belowTeaser' ],
            [ 'aboveTeaserImage' ],
            [ 'onTeaserImage' ],
            [ 'belowTeaserImage' ],
            [ 'aboveTeaserTitle' ],
            [ 'belowTeaserTitle' ],
        ];
    }

}
