<?php
namespace Newland\Toubiz\Events\Neos\Encoder;

use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;

class TopicsToQueryEncoder
{

    /**
     * @var array
     */
    private $queryOverride = [];

    /**
     * @param string[] $topicIdentifiers
     * @return array
     */
    public function encode(array $topicIdentifiers = [])
    {
        foreach ($topicIdentifiers as $topicId) {
            $this->addQueryOverride($topicId);
        }

        return $this->queryOverride;
    }

    private function addQueryOverride(string $combinedIdentifier)
    {
        if (strpos($combinedIdentifier, ':') === false) {
            return;
        }

        $types = [ TopicRepository::TYPE_TAG, TopicRepository::TYPE_CATEGORY ];
        if (preg_match($this->typeRegex($types), $combinedIdentifier, $matches)) {
            if ($matches['type'] === TopicRepository::TYPE_CATEGORY) {
                $this->addCategory($matches['identifier']);
            } elseif ($matches['type'] === TopicRepository::TYPE_TAG) {
                $this->addTag($matches['identifier']);
            }
        }
    }

    private function addCategory(string $identifier)
    {
        if (!isset($this->queryOverride['categories'])) {
            $this->queryOverride['categories'] = [];
        }
        $this->queryOverride['categories'][$identifier] = $identifier;
    }

    private function addTag(string $identifier)
    {
        if (!isset($this->queryOverride['eventTags'])) {
            $this->queryOverride['eventTags'] = [];
        }
        $this->queryOverride['eventTags'][$identifier] = $identifier;
    }


    /**
     * @param string[] $types
     * @return string
     */
    private function typeRegex(array $types): string
    {
        $typeRegexPart = implode('|', $types);
        return '/(?<type>' . $typeRegexPart . '):(?<identifier>[a-zA-Z0-9_\-]*)(:(?<value>[a-zA-Z0-9]+))?/';
    }
}
