<?php
namespace Newland\Toubiz\Events\Neos\Search\Indexer;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Search\Neos\Indexer\AbstractRecordIndexer;
use Newland\Toubiz\Search\Neos\Indexer\IndexerInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Filter\EventFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * Event indexer.
 *
 * Indexes events for the search.
 *
 * @Flow\Scope("singleton")
 */
class EventIndexer extends AbstractRecordIndexer implements IndexerInterface
{
    /**
     * @var EventRepository
     * @Flow\Inject
     */
    protected $eventRepository;

    /**
     * Entry point.
     *
     * Indexes article records.
     *
     * @return void
     */
    public function index()
    {
        $today = new \DateTime;
        $today->setTime(0, 0, 0);

        $filter = new EventFilter;
        $filter->setFromDate($today);

        foreach ($this->eventRepository->findByFilter($filter) as $event) {
            $this->indexEvent($event);
        }
    }

    /**
     * Runs post-index tasks such as cleaning up old records.
     *
     * @return void
     */
    public function postIndex()
    {
        $currentIndexIdentifiers = $this->searchIndexRepository->deleteObsolete(
            $this->index,
            get_class($this)
        );
    }

    /**
     * Indexes a given event.
     *
     * @param Event $event
     * @return void
     */
    protected function indexEvent(Event $event)
    {
        $content = [
            $event->getTitle(),
            $event->getDescription()
        ];

        $indexData = [
            'identifier' => $event->getPersistenceObjectIdentifier(),
            'source' => get_class($this),
            'title' => $this->convertToIndexableString($event->getTitle()),
            'description' => $this->convertToIndexableString($event->getDescription()),
            'content' => $this->convertToIndexableString(implode(' ', $content))
        ];

        $this->addToIndex($indexData);
    }
}
