<?php
namespace Newland\Toubiz\Events\Neos\Eel\Helper;

use Neos\Flow\Annotations as Flow;
use Neos\Eel\ProtectedContextAwareInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

class EventHelper implements ProtectedContextAwareInterface
{
    /**
     * @var EventRepository
     * @Flow\Inject()
     */
    protected $eventRepository;

    /**
     * @param string $identifier
     * @return Event|null
     */
    public function findByIdentifier(string $identifier)
    {
        if (!$identifier) {
            return null;
        }
        return $this->eventRepository->findByIdentifier($identifier);
    }

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'findByIdentifier';
    }
}
