# Toubiz events package for Neos CMS.

This package provides functionality for integrating events from toubiz into Neos.

## Configuration

### Settings
The following settings must be provided in order to fetch data from toubiz:

```
Newland:
  Toubiz:
    Events:
      Neos:
        apiKey: '<API KEY>'
        client: '<CLIENT NAME>'
```

Optional:
`organizer` can be used to restrict API results to a certain event organizer.

### Routing
For speaking urls, event sub routes must be registered in `Routes.yaml`:

```

-
  name: 'Events'
  uriPattern: '<EventsSubroutes>'
  subRoutes:
    'EventsSubroutes':
      package: 'Newland.Toubiz.Events.Neos'
```

#### Detail Page
The default path to the detail view is `/event/my-event-title` as defined in the settings:
```
Newland:
  Toubiz:
    Events:
      Neos:
        detailPage:
          _fallback: event
```
Override this in the site package if needed.

## Commands
The follwing commands are provided by this package:

 * `events:synchronize` to synchronize events between toubiz and the local database.
