<?php
namespace Newland\Toubiz\Events\Neos\DataSource;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Api\ObjectAdapter\Concern\EventConstants;

/**
 * POI data source service.
 *
 * @Flow\Scope("singleton")
 */
class EventScopeDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    static protected $identifier = 'newland-toubiz-events-neos-eventscope';

    /**
     * @var Translator
     * @Flow\Inject
     */
    protected $translator;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $data = [
            [
                'label' => $this->translator->translateById('property.scope.local', [], null, null, 'Models/Event', 'Newland.Toubiz.Events.Neos'),
                'value' => EventConstants::SCOPE_LOCAL
            ],
            [
                'label' => $this->translator->translateById('property.scope.regional', [], null, null, 'Models/Event', 'Newland.Toubiz.Events.Neos'),
                'value' => EventConstants::SCOPE_REGIONAL
            ],
            [
                'label' => $this->translator->translateById('property.scope.transregional', [], null, null, 'Models/Event', 'Newland.Toubiz.Events.Neos'),
                'value' => EventConstants::SCOPE_TRANSREGIONAL
            ]
        ];

        return $data;
    }
}
