<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\ViewHelpers\Widget\Controller;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Utility\Now;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Events\Neos\Filter\EventDateFilterFactory;

class TodayController extends AbstractWidgetController
{

    /**
     * @var Now
     * @Flow\Inject()
     */
    protected $now;

    /**
     * @var array
     * @Flow\InjectConfiguration(package="Newland.Toubiz.Events.Neos", path="filter")
     */
    protected $filterConfiguration;

    /** @var NodeInterface */
    protected $node;

    public function setNode(NodeInterface $node): void
    {
        $this->node = $node;
    }

    public function indexAction(): void
    {
        $overrides = (array) array_replace(
            (array) $this->node->getProperties(),
            [
                'numberOfDays' => [
                    'from' => $this->now->format('Y-m-d'),
                    'to' => $this->now->format('Y-m-d')
                ]
            ]
        );

        $eventDates = (new EventDateFilterFactory($this->widgetConfiguration['node']))
            ->createEventFilter($this->filterConfiguration, $overrides)
            ->setPageSize(100)
            ->getEventQuery()
            ->getQuery()
            ->execute();

        $this->view->assignMultiple(
            [
                'eventDates' => $eventDates,
                'node' => $this->node,
            ]
        );
    }
}
