<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Unit\ViewHelpers\Format;

use Neos\Flow\Tests\FunctionalTestCase;
use Neos\FluidAdaptor\View\StandaloneView;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class TimeRangeViewHelperTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var StandaloneView */
    protected $view;

    /** @var Event */
    protected $event;

    public function setUp(): void
    {
        parent::setUp();
        $this->view = $this->objectManager->get(StandaloneView::class);
        $this->view->getViewHelperResolver()->addNamespace('events', 'Newland\\Toubiz\\Events\\Neos\\ViewHelpers');
        $this->event = (new EventFactory($this->objectManager))->create();
    }

    public function testRendersOnlyDateIfStartAndEndOnSameDayAndStartTimeUndefined(): void
    {
        $this->addDate([
            'beginsAt' => '2020-01-01T14:00',
            'beginsAtSpecificTime' => false,
            'endsAt' => '2020-01-01T19:00',
            'endsAtSpecificTime' => true,
        ]);
        $this->assertEquals('2020-01-01', $this->render());
    }

    public function testRendersDateAndTimeIfStartAndEndOnSameDayAndStartAndEndTimeDefined(): void
    {
        $this->addDate([
               'beginsAt' => '2020-01-01T14:00',
               'beginsAtSpecificTime' => true,
               'endsAt' => '2020-01-01T19:00',
               'endsAtSpecificTime' => true,
           ]);
        $this->assertEquals('2020-01-01 14:00 — 19:00', $this->render());
    }

    public function testRendersStartDateAndTimeIfStartAndEndOnSameDayAndStartTimeDefined(): void
    {
        $this->addDate([
           'beginsAt' => '2020-01-01T14:00',
           'beginsAtSpecificTime' => true,
           'endsAt' => '2020-01-01T19:00',
           'endsAtSpecificTime' => false,
       ]);
        $this->assertEquals('2020-01-01 14:00', $this->render());
    }

    public function testRendersOnlyDatesIfDifferingDates(): void
    {
        $this->addDate([
           'beginsAt' => '2020-01-01T14:00',
           'beginsAtSpecificTime' => true,
           'endsAt' => '2020-01-01T19:00',
           'endsAtSpecificTime' => true,
       ]);
        $this->addDate([
           'beginsAt' => '2020-01-04T14:00',
           'beginsAtSpecificTime' => true,
           'endsAt' => '2020-01-04T19:00',
           'endsAtSpecificTime' => true,
       ]);
        $this->assertEquals('2020-01-01 — 2020-01-04', $this->render());
    }

    public function testRendersNothingIfNoDateExists(): void
    {
        $this->assertEquals('', $this->render());
    }

    private function addDate(array $properties): EventDate
    {
        $properties['event'] = $this->event;
        $date = (new EventDateFactory($this->objectManager))->create($properties);
        $this->event->getEventDates()->add($date);
        $this->persistenceManager->update($this->event);
        $this->persistenceManager->persistAll();
        return $date;
    }

    private function render(): string
    {
        $this->view->setTemplateSource('
            <events:format.timeRange
                event="{event}"
                dateFormat="yyyy-MM-dd"
                timeFormat="HH:mm"
                dateTimeFormat="yyyy-MM-dd HH:mm"
            />'
        );
        $this->view->assign('event', $this->event);
        return trim($this->view->render());
    }
}
