<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Format;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Crop format view helper.
 *
 * Crops given HTML to a simple text while ensuring
 * that the output is visually, technically and logically correct.
 */
class CropViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param integer $maxCharacters
     * @return string
     */
    public function render($maxCharacters = 120)
    {
        // Replace line breaks with a space to prevent sticky words.
        $content = preg_replace('/<br.?\/?>/', ' ', $this->renderChildren());

        // Strip off all tags.
        $content = strip_tags($content);

        // Decode HTML entities to prevent wrong string length calculations.
        $content = html_entity_decode($content);

        // Trim superfluous characters to prevent wrong string length calculation.
        $content = trim($content);

        // Calculate appendix if content length exceeds defined maximum.
        $length = strlen($content);
        $append = ($length > $maxCharacters) ? '...' : '';

        return substr($content, 0, $maxCharacters) . $append;
    }
}
