<?php
namespace Newland\Toubiz\Events\Neos\Utility;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

/**
 * DateTime utility.
 *
 * @Flow\Scope("singleton")
 */
class DateTimeUtility
{
    /**
     * Builds a DateTime object based on given params, or "today".
     *
     * @param string $year
     * @param string $month
     * @param string $day
     * @return \DateTime
     */
    public static function buildDateTimeObject($year = null, $month = null, $day = null)
    {
        $dateTime = new \DateTime;
        $dateTime->setDate(
            ($year ?? date('Y')),
            ($month ?? date('m')),
            ($day ?? date('d'))
        );
        $dateTime->setTime(0, 0);
        return $dateTime;
    }
}
