<?php
namespace Newland\Toubiz\Events\Neos\DataSource;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\I18n\Translator;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Api\ObjectAdapter\Concern\EventConstants;

/**
 * @Flow\Scope("singleton")
 */
class EventScopeDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    protected static $identifier = 'newland-toubiz-events-neos-eventscope';

    /**
     * @var Translator
     * @Flow\Inject()
     */
    protected $translator;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $data = [
            [
                'label' => $this->translate('property.scope.local'),
                'value' => EventConstants::SCOPE_LOCAL,
            ],
            [
                'label' => $this->translate('property.scope.regional'),
                'value' => EventConstants::SCOPE_REGIONAL,
            ],
            [
                'label' => $this->translate('property.scope.transregional'),
                'value' => EventConstants::SCOPE_TRANSREGIONAL,
            ]
        ];

        return $data;
    }

    /**
     * @param string $key
     * @return string
     */
    private function translate(string $key): string
    {
        return $this->translator->translateById($key, [], null, null, 'Models/Event', 'Newland.Toubiz.Events.Neos');
    }
}
