<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Newland\Contracts\Neos\Search\IndexRecordModification;
use Newland\Contracts\Neos\Search\SearchBackend;
use Newland\Contracts\Neos\Search\SearchRequest;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventAdapter;
use Newland\Toubiz\Events\Neos\Search\Indexer\EventIndexer;
use Newland\Toubiz\Search\Neos\Progress\NullHandler;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Importer\EventImporter;
use Newland\Contracts\Neos\Search\SearchResultCollection;

class EventIndexerTest extends IntegrationTestCase implements SearchBackend
{

    /** @var IndexRecordModification[] */
    protected $entries = [];

    public function testIndexesImportedEventFromToubiz(): void
    {
        $data = json_decode(file_get_contents(__DIR__ . '/Fixtures/toubiz-event-with-searchword.json'), true);
        $adapter = new EventAdapter($data);

        $imported = (new EventImporter())->import($adapter);
        $event = $this->persistenceManager->getObjectByIdentifier(
            $imported->getPersistenceObjectIdentifier(),
            Event::class
        );

        $this->objectManager->get(EventIndexer::class)->index(['/sites/foo'], $this, new NullHandler());

        $this->assertCount(1, $this->entries);
        $this->assertEquals($event->getPersistenceObjectIdentifier(), $this->entries[0]->getIdentifier());
        $this->assertEquals('DoDaFest...', $this->entries[0]->getTitle());
        $this->assertStringContainsString('dodasuche', $this->entries[0]->getContent());
    }

    public function testDoesNotIndexOutdatedImportedEventFromToubiz(): void
    {
        $data = json_decode(file_get_contents(__DIR__ . '/Fixtures/toubiz-outdated-event-with-searchword.json'), true);
        $adapter = new EventAdapter($data);

        $imported = (new EventImporter())->import($adapter);
        $this->persistenceManager->getObjectByIdentifier(
            $imported->getPersistenceObjectIdentifier(),
            Event::class
        );

        $this->objectManager->get(EventIndexer::class)->index(['/sites/foo'], $this, new NullHandler());

        $this->assertCount(0, $this->entries);
    }

    public function initialize(): void
    {
        // Mock implementation of search backend
    }

    public function setSource(string $source): void
    {
        // Mock implementation of search backend
    }

    public function createOrUpdateIndexEntry(IndexRecordModification $modification): void
    {
        $this->entries[] = $modification;
    }

    public function afterIndexing(): void
    {
        // Mock implementation of search backend
    }

    public function deleteObsoleteIndexEntries(array $identifiersToRetain): void
    {
        // Mock implementation of search backend
    }

    public function search(SearchRequest $request): SearchResultCollection
    {
        // Mock implementation of search backend
    }

}
