<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Teaser;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use DateTime;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Events\Neos\ViewHelpers\Link\EventViewHelper;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Simple ViewHelper that checks whether an event is expired.
 *
 * @example
 * The following example will only render content, if the current event exists and is not expired:
 * <f:if condition="{events:teaser.isExpired(event: event)} == false">
 * </f:if>
 */

class IsExpiredViewHelper extends AbstractViewHelper
{
    public function render(Event $event = null): bool
    {
        if ($event) {
            $today = new DateTime();
            return $event->getEndsAt() < $today &&
            ($event->getBeginsAt()->format('Y-m-d H:i:s') !== $event->getEndsAt()->format('Y-m-d H:i:s'));
        } else {
            return true;
        }
    }
}
