<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Meta;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Property\PropertyMapper;
use Newland\NeosMetaTags\Domain\Model\CanonicalUrlGenerator as CanonicalUrlGeneratorInterface;
use Newland\NeosMetaTags\Domain\Model\Scenario;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Neos\Flow\Annotations as Flow;

class CanonicalUrlGenerator implements CanonicalUrlGeneratorInterface
{

    /**
     * @var EventUrlService
     * @Flow\Inject()
     */
    protected $eventUrlService;

    /**
     * @var PropertyMapper
     * @Flow\Inject()
     */
    protected $propertyMapper;

    public function generate(Scenario $scenario, $record): ?string
    {
        if (!($record instanceof Event)) {
            return null;
        }

        return $this->eventUrlService->generateUrlByCurrentNode(
            $record,
            $this->propertyMapper->convert($scenario->getNodePath(), Node::class),
            null,
            true
        );
    }
}
