<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Neos\Flow\Utility\Now;
use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventDate;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventDateFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventFactory;

class DetailPageTest extends IntegrationTestCase
{

    /** @var Event */
    protected $event;

    /** @var EventDate[] */
    protected $dates;

    public function setUp(): void
    {
        parent::setUp();

        $this->objectManager->setInstance(Now::class, new Now('2019-01-01T06:00'));

        $this->dates = [
            $this->eventDateFactory->create([ 'beginsAt' => '2019-01-01T14:00', 'endsAt' => '2019-01-01T17:00' ]),
            $this->eventDateFactory->create([ 'beginsAt' => '2019-01-02T12:00', 'endsAt' => '2019-01-02T15:00' ]),
            $this->eventDateFactory->create([ 'beginsAt' => '2019-01-03T06:00', 'endsAt' => '2019-01-03T18:00' ]),
        ];

        $this->event = $this->eventFactory->create([
            'title' => 'foo bar test',
            'eventDates' => $this->dates,
        ]);
    }

    public function tearDown(): void
    {
        $this->objectManager->forgetInstance(Now::class);
        parent::tearDown();
    }

    public function testRendersDetailView(): void
    {
        $response = $this->browser->request(
            $this->eventUrlService->generateUrlByCurrentNode($this->event, $this->documentNode)
        );
        $this->assertResponseOk($response);
    }

    public function testRendersDetailViewForDates(): void
    {
        $this->assertResponseOk($this->browser->request(
            $this->eventUrlService->generateUrlByCurrentNode(
                $this->event,
                $this->documentNode,
                $this->dates[0]
            )
        ));
        $this->assertResponseOk($this->browser->request(
            $this->eventUrlService->generateUrlByCurrentNode(
                $this->event,
                $this->documentNode,
                $this->dates[1]
            )
        ));
        $this->assertResponseOk($this->browser->request(
            $this->eventUrlService->generateUrlByCurrentNode(
                $this->event,
                $this->documentNode,
                $this->dates[2]
            )
        ));
    }

    // See TBEVENTS-132
    public function testRendersTimesOfRecurringEventsCorrectly(): void
    {
        $response = $this->browser->request(
            $this->eventUrlService->generateUrlByCurrentNode($this->event, $this->documentNode)
        );
        $this->assertResponseOk($response);

        $bodyWithoutTags = preg_replace(
            '/\s+/',
            ' ',
            strip_tags((string) $response->getBody())
        );
        $this->assertContains('01.01.2019 | 14:00 – 17:00', $bodyWithoutTags);
        $this->assertContains('02.01.2019 | 12:00 – 15:00', $bodyWithoutTags);
        $this->assertContains('03.01.2019 | 06:00 – 18:00', $bodyWithoutTags);
    }

}
