<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

use Newland\Toubiz\Api\ObjectAdapter\Concern\EventConstants;

class IndexListTest extends IntegrationTestCase
{
    public function setUp(): void
    {
        parent::setUp();
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Events.Neos:List'));
        $this->persistNode($this->node);
        $this->nodeService->createChildNodes($this->node);
        $this->persistenceManager->persistAll();
    }

    public function testDoesNotThrowError(): void
    {
        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
    }

    public function testOnlyDisplaysEventsThatHaveDatesInTheFuture(): void
    {
        $this->eventFactory->create([ 'title' => 'NO_DATES' ]);

        $tomorrow = (new \DateTime())->add(new \DateInterval('P1D'));
        $eventTomorrow = $this->eventFactory->create([ 'title' => 'DATE_TOMORROW' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $tomorrow,
                'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')),
                'event' => $eventTomorrow,
            ]
        );

        $yesterday = (new \DateTime())->sub(new \DateInterval('P1D'));
        $eventYesterday = $this->eventFactory->create([ 'title' => 'DATE_YESTERDAY' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $yesterday,
                'endsAt' => (clone $yesterday)->add(new \DateInterval('PT1H')),
                'event' => $eventYesterday,
            ]
        );

        $dayAfterTomorrow = (new \DateTime())->add(new \DateInterval('P2D'));
        $eventDayAfterTomorrow = $this->eventFactory->create([ 'title' => 'DATE_DAY_AFTER_TOMORROW' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $dayAfterTomorrow,
                'endsAt' => (clone $dayAfterTomorrow)->add(new \DateInterval('PT1H')),
                'event' => $eventDayAfterTomorrow,
            ]
        );

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);

        $this->assertResponseContains('DATE_TOMORROW', $response);
        $this->assertResponseContains('DATE_DAY_AFTER_TOMORROW', $response);
        $this->assertResponseNotContains('NO_DATES', $response);
        $this->assertResponseNotContains('DATE_YESTERDAY', $response);
    }


    public function testOnlyDisplaysNodesOfCertainScope(): void
    {
        $tomorrow = (new \DateTime())->add(new \DateInterval('P1D'));

        $local = $this->eventFactory->create([ 'scope' => EventConstants::SCOPE_LOCAL, 'title' => 'SCOPE_LOCAL' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $tomorrow,
                'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')),
                'event' => $local,
            ]
        );

        $regional =
            $this->eventFactory->create([ 'scope' => EventConstants::SCOPE_REGIONAL, 'title' => 'SCOPE_REGIONAL' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $tomorrow,
                'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')),
                'event' => $regional,
            ]
        );

        $trans = $this->eventFactory->create(
            [ 'scope' => EventConstants::SCOPE_TRANSREGIONAL, 'title' => 'SCOPE_TRANSREGIONAL' ]
        );
        $this->eventDateFactory->create(
            [
                'beginsAt' => $tomorrow,
                'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')),
                'event' => $trans,
            ]
        );

        $undefined =
            $this->eventFactory->create([ 'scope' => EventConstants::SCOPE_UNDEFINED, 'title' => 'SCOPE_UNDEFINED' ]);
        $this->eventDateFactory->create(
            [
                'beginsAt' => $tomorrow,
                'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')),
                'event' => $undefined,
            ]
        );

        $this->node->setProperty('eventScope', [ EventConstants::SCOPE_LOCAL ]);
        $this->persistNode($this->node);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);


        $this->assertResponseContains('SCOPE_LOCAL', $response);
        $this->assertResponseNotContains('SCOPE_REGIONAL', $response);
        $this->assertResponseNotContains('SCOPE_TRANSREGIONAL', $response);
        $this->assertResponseNotContains('SCOPE_UNDEFINED', $response);
    }

    // TODO Add test for preselectedRegions
    // TODO Add test for topics
    // TODO Add test for preselectedTopics
}
