<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Integration;

class TeaserListTest extends IntegrationTestCase
{
    public function setUp(): void
    {
        parent::setUp();
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Events.Neos:TeaserList'));
        $this->node->setProperty('recordLimit', 5);
        $this->persistNode($this->node);
    }

    public function testDoesNotThrowError(): void
    {

        $tomorrow = (new \DateTime())->add(new \DateInterval('P1D'));
        $dateTomorrow = $this->eventFactory->create([ 'title' => 'DATE_TOMORROW' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $tomorrow, 'endsAt' => (clone $tomorrow)->add(new \DateInterval('PT1H')), 'event' => $dateTomorrow ]);

        $yesterday = (new \DateTime())->sub(new \DateInterval('P1D'));
        $dateYesterday = $this->eventFactory->create([ 'title' => 'DATE_YESTERDAY' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $yesterday, 'endsAt' => (clone $yesterday)->add(new \DateInterval('PT1H')), 'event' => $dateYesterday ]);

        $dayAfterTomorrow = (new \DateTime())->add(new \DateInterval('P2D'));
        $dateYesterday = $this->eventFactory->create([ 'title' => 'DATE_DAY_AFTER_TOMORROW' ]);
        $this->eventDateFactory->create([ 'beginsAt' => $dayAfterTomorrow, 'endsAt' => (clone $dayAfterTomorrow)->add(new \DateInterval('PT1H')), 'event' => $dateYesterday ]);

        $response = $this->browser->request($this->nodeUri);
        $this->assertResponseOk($response);
    }

}
