<?php
namespace Newland\Toubiz\Events\Neos\Tests\Unit\Utility;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Events\Neos\Utility\IntegerUtility;

class IntegerUtilityTest extends UnitTestCase
{
    /**
     * @var IntegerUtility
     */
    protected $subject;

    public function setUp()
    {
        $this->subject = new IntegerUtility();
    }

    /**
     * @param mixed $input
     * @param int $expected
     *
     * @dataProvider getNormalizeToPositiveExamples
     */
    public function testNormalizeToPositiveValue($input, int $expected)
    {
        $this->assertEquals($expected, $this->subject::normalizeToPositiveValue($input));
    }

    public function getNormalizeToPositiveExamples(): array
    {
        return [
            [ null, 1 ],
            [ 1, 1 ],
            [ 5, 5 ],
            [ '2', 2 ],
            [ '', 1 ],
            [ -1, 1 ],
        ];
    }
}
