<?php declare(strict_types=1);

namespace Newland\Toubiz\Events\Neos\Tests\Unit\Domain\Repository;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventTagRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\CategoryFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\EventTagFactory;

class TopicRepositoryTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var TopicRepository */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(TopicRepository::class);
    }

    public function testFindsAllTopicsForCategoriesInGivenLanguage(): void
    {
        $factory = new CategoryFactory($this->objectManager);
        $german = $factory->create([ 'language' => 'de' ]);
        $english = $factory->create([ 'language' => 'en' ]);

        $this->subject->setLanguage('de');
        $tags = $this->subject->findAllCategory();
        $ids = array_map(
            function(Topic $topic) {
                return $topic->getCombinedIdentifier();
            },
            $tags
        );

        $this->assertContains('category:' . $german->getPersistenceObjectIdentifier(), $ids);
        $this->assertNotContains('category:' . $english->getPersistenceObjectIdentifier(), $ids);
    }

    public function testFindsAllTopicsForTagsInGivenLanguage(): void
    {
        $factory = new EventTagFactory($this->objectManager);
        $german = $factory->create([ 'language' => 'de' ]);
        $english = $factory->create([ 'language' => 'en' ]);

        $this->subject->setLanguage('de');
        $tags = $this->subject->findAllEventTag();
        $ids = array_map(
            function(Topic $topic) {
                return $topic->getCombinedIdentifier();
            },
            $tags
        );

        $this->assertContains('eventTag:' . $german->getPersistenceObjectIdentifier(), $ids);
        $this->assertNotContains('eventTag:' . $english->getPersistenceObjectIdentifier(), $ids);
    }

    public function testSettingLanguageDoesNotTaintRepositories(): void
    {
        $eventTagRepository = $this->objectManager->get(EventTagRepository::class);
        $categoryRepository = $this->objectManager->get(EventRepository::class);
        $eventTagRepository->setLanguage('de');
        $categoryRepository->setLanguage('de');

        $this->subject->setLanguage('en');
        $this->subject->findAll();

        $this->assertEquals('de', $eventTagRepository->getLanguage());
        $this->assertEquals('de', $categoryRepository->getLanguage());
    }
}
