<?php
namespace Newland\Toubiz\Events\Neos\DataSource;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Events\Neos\Service\RegionService;
use Neos\Flow\Annotations as Flow;

/**
 * @Flow\Scope("singleton")
 */
class RegionsDataSource extends AbstractDataSource
{
    protected static $identifier = 'newland-toubiz-events-neos-regions';

    /**
     * @var RegionService
     * @Flow\Inject()
     */
    protected $regionService;

    public function getData(NodeInterface $node = null, array $arguments = []): array
    {
        if ($node === null) {
            return [];
        }

        $regions = [];
        foreach ($this->regionService->getAllEnabled($node) as $key => $region) {
            $regions[] = [ 'label' => $region['name'], 'value' => $key ];
        }

        return $regions;
    }
}
