<?php
namespace Newland\Toubiz\Events\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Events\Neos\Domain\Model\Tag;
use Newland\Toubiz\Sync\Neos\Domain\Model\Category;
use Newland\Toubiz\Sync\Neos\Domain\Model\EventTag;

class TagRepository
{
    const TYPE_CATEGORY = TopicRepository::TYPE_CATEGORY;
    const TYPE_TAG = TopicRepository::TYPE_TAG;

    public function findOneByCategory(Category $category): Tag
    {
        return new Tag(
            static::TYPE_CATEGORY . ':' . $category->getPersistenceObjectIdentifier(),
            $category->getTitle()
        );
    }

    public function findOneByEventTag(EventTag $eventTag): Tag
    {
        return new Tag(
            static::TYPE_TAG . ':' . $eventTag->getPersistenceObjectIdentifier(),
            $eventTag->getKeyword()
        );
    }

    public function findOneByRegion(Topic $region): Tag
    {
        return new Tag(
            $region->getCombinedIdentifier(),
            $region->getTitle()
        );
    }
}
