<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Format;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use function Safe\preg_replace;

/**
 * Crop format view helper.
 *
 * Crops given HTML to a simple text while ensuring
 * that the output is visually, technically and logically correct.
 */
class CropViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param int $maxCharacters
     * @param string $append
     * @return string
     */
    public function render(int $maxCharacters = 120, string $append = '...'): string
    {
        $content = (string) $this->renderChildren();
        $content = $this->removeAllHtmlTags($content);

        // TODO check for XSS vulnerabilities that could arise from decoding HTML entities.
        $content = $this->removeEntitiesThatPreventCorrectLengthCalculations($content);

        $exceedsLength = strlen($content) > $maxCharacters;
        if (!$exceedsLength) {
            $append = '';
        }
        return substr($content, 0, $maxCharacters) . $append;
    }

    private function removeAllHtmlTags(string $content): string
    {
        // Replace line breaks with spaces
        $result = preg_replace('/<br.?\/?>/', ' ', $content);
        $content = is_string($result) ? $result : '';

        return strip_tags($content);
    }

    private function removeEntitiesThatPreventCorrectLengthCalculations(string $content): string
    {
        return trim(html_entity_decode($content));
    }
}
