<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Filter\Controller;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\View\ViewInterface;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\FluidAdaptor\View\TemplateView;
use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;
use Newland\Toubiz\Events\Neos\Service\RegionService;
use Newland\Toubiz\Sync\Neos\Domain\Repository\AttributeRepository;
use TYPO3Fluid\Fluid\Core\ViewHelper\ViewHelperVariableContainer;

class FieldSetController extends AbstractWidgetController
{
    /**
     * @var TopicRepository
     * @Flow\Inject
     */
    protected $topicRepository;

    /**
     * @var AttributeRepository
     * @Flow\Inject
     */
    protected $attributeRepository;

    /**
     * @var RegionService
     * @Flow\Inject
     */
    protected $regionService;

    /**
     * @var array
     */
    protected $viewHelperVariables = [];

    public function passViewHelperVariables(ViewHelperVariableContainer $container, array $viewHelpers)
    {
        foreach ($viewHelpers as $class) {
            $this->viewHelperVariables[$class] = $container->getAll($class) ?: [];
        }
    }

    /**
     * @param TemplateView $view
     */
    public function initializeView(ViewInterface $view)
    {
        foreach ($this->viewHelperVariables as $class => $variables) {
            $view->getRenderingContext()->getViewHelperVariableContainer()->addAll($class, $variables);
        }
    }

    public function indexAction()
    {
        $type = $this->widgetConfiguration['fieldSet']['type'];

        $this->view->assignMultiple(
            [
                'name' => $this->widgetConfiguration['name'],
                'fieldSet' => $this->widgetConfiguration['fieldSet'],
                'type' => $type,
                'random' => md5((string) mt_rand()),
                'nodeIdentifier' => $this->getNodeIdentifier(),
            ]
        );

        $method = 'handle' . ucfirst($type);

        if (method_exists($this, $method)) {
            $this->{$method}();
        }
    }

    private function handleTags()
    {
        $fieldSet = $this->widgetConfiguration['fieldSet'];
        $fieldSet['searchable'] = true;

        $this->view->assignMultiple(
            [
                'type' => 'checkboxes',
                'items' => $this->topicRepository->findAllEventTag(),
                'fieldSet' => $fieldSet,
            ]
        );
    }

    private function handleCategories()
    {
        $fieldSet = $this->widgetConfiguration['fieldSet'];
        $fieldSet['searchable'] = true;

        $this->view->assignMultiple(
            [
                'type' => 'checkboxes',
                'items' => $this->topicRepository->findAllCategorySortedByNumberOfEvents(),
                'fieldSet' => $fieldSet,
            ]
        );
    }

    private function handleRegions()
    {
        $fieldSet = $this->widgetConfiguration['fieldSet'];
        $fieldSet['searchable'] = true;

        $this->view->assignMultiple(
            [
                'type' => 'checkboxes',
                'items' => $this->regionService->regionsAttainable(),
                'fieldSet' => $fieldSet,
            ]
        );
    }

    private function handleCheckboxes()
    {
        $this->view->assignMultiple(
            [
                'items' => $this->topicRepository->findByIdentifiers($this->widgetConfiguration['fieldSet']['items']),
            ]
        );
    }

    private function handleRange()
    {
        $steps = $this->widgetConfiguration['fieldSet']['steps'] ?? 1;
        $factor = $this->widgetConfiguration['fieldSet']['factor'] ?? 1;
        $min = $this->widgetConfiguration['fieldSet']['min'] ?? null;
        $max = $this->widgetConfiguration['fieldSet']['max'] ?? null;

        if (!$min || !$max) {
            list(, $name) = explode(':', $this->widgetConfiguration['fieldSet']['item']);
            $roundAutoBounds = $this->widgetConfiguration['fieldSet']['roundAutoBounds'] ?? 100;
            $bounds = $this->attributeRepository->getNumberBoundsForName($name, $roundAutoBounds);
            $min = $min ?? $bounds['min'];
            $max = $max ?? $bounds['max'];
        }

        $this->view->assignMultiple(
            [
                'item' => $this->topicRepository->findByIdentifier($this->widgetConfiguration['fieldSet']['item']),
                'min' => $min,
                'max' => $max,
                'steps' => $steps,
                'factor' => $factor,
            ]
        );
    }

    private function getNodeIdentifier(): string
    {
        /** @var NodeInterface $node */
        $node = $this->widgetConfiguration['node'];
        $nodeIdentifier = $node->getIdentifier();

        return $nodeIdentifier;
    }
}
