<?php
namespace Newland\Toubiz\Events\Neos\Tests\Unit\Service;


use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Events\Neos\Service\QueryOverride;

class QueryOverrideTest extends FunctionalTestCase
{

    /** @var QueryOverride */
    private $subject;

    public function setUp()
    {
        parent::setUp();
        $this->subject = new QueryOverride();
    }

    public function testOverridesCategoriesFromPreselectedTopics(): void
    {
        $this->subject->initialize([ 'preselectedTopics' => [ 'category:abc-456-def' ] ]);

        $override = $this->subject->getOverride();
        $this->assertArrayHasKey('categories', $override);
        $this->assertContains('abc-456-def', $override['categories']);
    }

    public function testOverridesTagsFromPreselectedTopics(): void
    {
        $this->subject->initialize([ 'preselectedTopics' => [ 'eventTag:foobar' ] ]);

        $override = $this->subject->getOverride();
        $this->assertArrayHasKey('eventTags', $override);
        $this->assertContains('foobar', $override['eventTags']);
    }

}
