<?php
namespace Newland\Toubiz\Events\Neos\Listener;

use Doctrine\ORM\EntityManagerInterface;
use Neos\ContentRepository\Domain\Factory\NodeFactory;
use Neos\Flow\Cli\ConsoleOutput;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Neos\Neos\Domain\Repository\SiteRepository;
use Newland\NeosCommon\Domain\Repository\NodeRepository;
use Newland\Toubiz\Events\Neos\Service\EventUrlService;
use Newland\NeosCommon\Service\ControllerContextFactory;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Sync\Neos\Command\EventsCommandController;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * @Flow\Scope("singleton")
 */
class BuildUrls
{
    /**
     * @Flow\Inject
     * @var NodeRepository
     */
    protected $nodeRepository;

    /**
     * @Flow\Inject
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @Flow\Inject
     * @var NodeFactory
     */
    protected $nodeFactory;

    /**
     * @Flow\Inject
     * @var ControllerContextFactory
     */
    protected $contextFactory;

    /**
     * @Flow\Inject
     * @var SiteRepository
     */
    protected $siteRepository;

    /**
     * @var EventUrlService
     * @Flow\Inject
     */
    protected $eventUrlService;

    /**
     * @var EventRepository
     * @Flow\Inject
     */
    protected $eventRepository;

    /**
     * @var ConsoleOutput
     * @api
     */
    protected $output;

    /**
     * @Flow\Inject
     * @var PersistenceManagerInterface
     */
    protected $persistenceManager;


    const NODE_TYPE = 'Neos.NodeTypes:Page';

    public function run(string $type)
    {
        $this->output = new ConsoleOutput();
        if ($type === EventsCommandController::TYPE_FLUSH) {
            $this->output->outputLine("\nGenerating Event URLs");
            $this->generateEventUrls();
        }
    }

    protected function persistAndFlushEntityReferencesFromPersistenceManager(): void
    {
        $this->persistenceManager->persistAll();
        $this->persistenceManager->clearState();
    }

    private function generateEventUrls()
    {
        $batchSize = 1000;
        $node = $this->nodeRepository
            ->findOneByNodeType(static::NODE_TYPE, true);
        $context = $this->contextFactory->initializeFakeControllerContext($node);
        $iterableResult = $this->eventRepository->findAllIterator();

        $this->output->progressStart(0);

        foreach ($iterableResult as $i => $eventRow) {
            $event = $eventRow[0];
            $this->eventUrlService->generateUrl($event, $context);
            $this->output->progressSet($i);
            $this->output->output(EventsCommandController::TYPE_FLUSH);
            if (($i % $batchSize) === 0) {
                $this->persistAndFlushEntityReferencesFromPersistenceManager();
            }
        }

        $this->output->progressFinish();
        $this->output->outputLine('Done');
    }
}
