<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Filter;

/*
 * This file is part of the "toubiz-poi-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\NeosCommon\Domain\Model\Topic;
use Newland\Toubiz\Events\Neos\Domain\Repository\TopicRepository;

/**
 * Builds a query object for the given topic.
 */
class QueryViewHelper extends AbstractViewHelper
{
    public static function queryPathForFilterItem(Topic $topic, bool $addValueIfExists = true): array
    {
        switch ($topic->getType()) {
            case TopicRepository::TYPE_CATEGORY:
                $query = [ 'categories' ];
                break;
            case TopicRepository::TYPE_TAG:
                $query = [ 'eventTags' ];
                break;
            case TopicRepository::TYPE_REGION:
                $query = [ 'regions' ];
                break;
            default:
                $query = [];
                break;
        }

        if ($addValueIfExists) {
            $query[] = $topic->getValueOrIdentifier();
        }

        return $query;
    }

    public function render(Topic $topic): array
    {
        $path = static::queryPathForFilterItem($topic);

        $query = [];
        $current = &$query;
        foreach ($path as $part) {
            $current[$part] = [];
            $current = &$current[$part];
        }

        $current = $topic->getValueOrIdentifier();
        return $query;
    }
}
