<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\Events\Neos\ViewHelpers\Widget\Controller\TeaserController;

/**
 * Renders the teaser widget.
 */
class TeaserViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @Flow\Inject
     * @var TeaserController
     */
    protected $controller;

    /**
     * Render this view helper.
     *
     * @param NodeInterface $node   The current node.
     * @param array         $filter Options for the event filter.
     * @return string
     */
    public function render(NodeInterface $node, $filter = [])
    {
        $response = $this->initiateSubRequest();
        return $response->getContent();
    }
}
