<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\Toubiz\Events\Neos\Utility\DateTimeUtility;
use Newland\Toubiz\Sync\Neos\Domain\Filter\EventFilter;
use Newland\Toubiz\Sync\Neos\Domain\Repository\EventRepository;

/**
 * The widget controller for the teaser widget.
 */
class TeaserController extends AbstractWidgetController
{
    /**
     * @Flow\Inject
     * @var EventRepository
     */
    protected $eventRepository;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction()
    {
        $filterConfiguration = $this->prepareFilterConfiguration($this->widgetConfiguration['filter']);
        $filter = new EventFilter;
        $filter->initialize($filterConfiguration);
        $this->view->assignMultiple([
            'currentDate' => DateTimeUtility::buildDateTimeObject(),
            'events' => $this->eventRepository->findByFilter($filter)
        ]);

        $targetNode = $this->getTargetNode();
        if ($targetNode) {
            $this->view->assign('targetNode', $targetNode);
        }
    }

    /**
     * Finds the page node type that contains the full plugin.
     *
     * @return Node|null
     */
    protected function getTargetNode()
    {
        $site = $this->widgetConfiguration['node']->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.Events.Neos:Full]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }

    /**
     * Prepares filter configuration by ensuring defaults are present.
     *
     * @param array $configuration
     * @return array
     */
    protected function prepareFilterConfiguration($configuration)
    {
        $today = DateTimeUtility::buildDateTimeObject();
        return array_merge(
            [
                'limit' => 3,
                'fromDate' => $today
            ],
            $configuration
        );
    }
}
