<?php
namespace Newland\Toubiz\Events\Neos\ViewHelpers\Context;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Sync\Neos\Domain\Model\Event;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Event date view helper.
 *
 * If a given day is viewed, events should not display the
 * original beginning date but the current day.
 */
class EventDateViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param Event $event
     * @param \DateTime $currentDate
     * @return \DateTime
     */
    public function render(Event $event, \DateTime $currentDate)
    {
        $date = $event->getBeginsAt();
        $date->setDate(
            $currentDate->format('Y'),
            $currentDate->format('m'),
            $currentDate->format('d')
        );

        return $date;
    }
}
