<?php
namespace Newland\Toubiz\Events\Neos\Importer;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Events\Neos\Domain\Model\Address;
use Newland\Toubiz\Events\Neos\Domain\Repository\AddressRepository;

/**
 * Address importer.
 *
 * @Flow\Scope("singleton")
 */
class AddressImporter extends AbstractImporter
{
    /**
     * @var array The parent object being imported.
     */
    protected $parentObject;

    /**
     * @Flow\Inject
     * @var AddressRepository
     */
    protected $addressRepository;

    /**
     * @param array $parentObject
     * @return void
     */
    public function setParentObject($parentObject)
    {
        $this->parentObject = $parentObject;
    }

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     *
     * @param AddressAdapterInterface $data
     * @return Address
     */
    public function import($data)
    {
        $address = $this->addressRepository->findOneByOriginalId($data->getExternalId());
        $persisted = !!$address;

        if (!$address) {
            $address = new Address;
        }

        if (!$address->getOriginalId()) {
            $address->setOriginalId($data->getExternalId());
        }

        $address->setName($data->getTitle());
        $address->setFirstName($data->getFirstName());
        $address->setLastName($data->getLastName());
        $address->setStreet($data->getStreet());
        $address->setZip($data->getZip());
        $address->setCity($data->getCity());

        if ($persisted) {
            $this->addressRepository->update($address);
        } else {
            $this->addressRepository->add($address);
        }

        // Persisting is required due to the API returning the same object multiple times!
        $this->persistenceManager->persistAll();

        return $address;
    }
}
