<?php
namespace Newland\Toubiz\Events\Neos\Importer;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\PersistenceManagerInterface;

/**
 * Abstract importer class.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractImporter
{
    /**
     * @Flow\Inject
     * @var PersistenceManagerInterface
     */
    protected $persistenceManager;

    /**
     * Main import method.
     *
     * Must be defined in each implementation.
     *
     * @param array $data
     * @return mixed
     */
    abstract public function import($data);

    /**
     * Returns a DateTime instance for given object.
     *
     * @param mixed $object
     * @return \DateTime
     */
    protected function asDateTime($object)
    {
        if (is_string($object)) {
            return new \DateTime($object);
        } else {
            return $object;
        }
    }

    /**
     * Converts date and time strings into a DateTime object.
     *
     * @param string $date A date in YYYY-MM-DD format
     * @param string $time A time in hh:mm:ss format
     * @return \DateTime
     */
    protected function buildDateTimeFromStrings($date, $time = '')
    {
        $object = new \DateTime($date);
        if ($time) {
            list($hour, $minute, $_) = explode(':', $time);
            $object->setTime((int)$hour, (int)$minute);
        }
        return $object;
    }

    /**
     * Finds the first matching key/value pair inside an array of arrays.
     *
     * @param array $array
     * @param mixed $searchKey
     * @param mixed $searchValue
     * @return array|null
     */
    protected function findInArray(array $array, $searchKey, $searchValue)
    {
        $result = array_filter(
            $array,
            function ($item) use ($searchKey, $searchValue) {
                return ((array)$item)[$searchKey] == $searchValue;
            }
        );

        if (count($result)) {
            return array_shift($result);
        }
    }
}
