<?php
namespace Newland\Toubiz\Events\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\QueryInterface;
use Neos\Flow\Persistence\Doctrine\Repository;

/**
 * Event repository.
 *
 * @Flow\Scope("singleton")
 */
class EventRepository extends Repository
{
    /**
     * Finds upcoming events.
     *
     * @param int $limit
     * @param mixed $highlight
     * @return QueryResultInterface
     */
    public function findUpcoming($limit, $highlight = null)
    {
        $query = $this->createQuery();

        $constraints = [
            $query->greaterThanOrEqual('endsAt', (new \DateTime()))
        ];

        if ($highlight) {
            $constraints[] = $query->equals('isHighlight', true);
        }

        $query->matching($query->logicalAnd($constraints));
        $query->setOrderings(['beginsAt' => QueryInterface::ORDER_ASCENDING]);
        $query->setLimit($limit);
        return $query->execute();
    }

    /**
     * Finds events that happen on a given date.
     *
     * @param \DateTime $date
     * @return QueryResultInterface
     */
    public function findByDate(\DateTime $date)
    {
        $query = $this->createQueryBuilder('event');
        return $query
                ->join('event.eventDates', 'eventDate')
                ->where('DATE(eventDate.beginsAt) <= :date AND (eventDate.endsAt) >= :date')
                ->setParameter('date', $date->format('Y-m-d'))
                ->getQuery()
                ->execute();
    }
}
