<?php
namespace Newland\Toubiz\Events\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Events\Neos\Domain\Model\Event;

/**
 * A multimedia item.
 *
 * @Flow\Entity
 */
class Medium extends AbstractEntity
{
    /**
     * @ORM\ManyToOne(inversedBy="medium")
     * @var Event
     */
    protected $event;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $sourceUri;

    /**
     * @var string
     */
    protected $copyright;

    /**
     * @param Event $event
     * @return void
     */
    public function setEvent(Event $event)
    {
        $this->event = $event;
    }

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $sourceUri
     * @return void
     */
    public function setSourceUri($sourceUri)
    {
        $this->sourceUri = $sourceUri;
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return $this->sourceUri;
    }

    /**
     * @param string $copyright
     * @return void
     */
    public function setCopyright($copyright)
    {
        $this->copyright = $copyright;
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
        return $this->copyright;
    }
}
