<?php
namespace Newland\Toubiz\Events\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Events\Neos\Domain\Model\Event;
use Neos\Flow\Annotations as Flow;

/**
 * A date/time an event is going on.
 *
 * @Flow\Entity
 */
class EventDate extends AbstractEntity
{
    /**
     * @ORM\ManyToOne(inversedBy="eventDates")
     * @var Event
     */
    protected $event;

    /**
     * @var \DateTime Start time of this date.
     */
    protected $beginsAt;

    /**
     * @var \DateTime End time of this date.
     */
    protected $endsAt;

    /**
     * @var string A note added to this event date.
     */
    protected $note;

    /**
     * @param Event $event
     * @return void
     */
    public function setEvent(Event $event)
    {
        $this->event = $event;
    }

    /**
     * @param \DateTime $beginsAt
     * @return void
     */
    public function setBeginsAt(\DateTime $beginsAt)
    {
        $this->beginsAt = $beginsAt;
    }

    /**
     * @return \DateTime
     */
    public function getBeginsAt()
    {
        return $this->beginsAt;
    }

    /**
     * @return bool
     */
    public function getBeginsAtSpecificTime()
    {
        return ((int)$this->beginsAt->format('H') > 0);
    }

    /**
     * @param \DateTime $endsAt
     * @return void
     */
    public function setEndsAt(\DateTime $endsAt)
    {
        $this->endsAt = $endsAt;
    }

    /**
     * @return \DateTime
     */
    public function getEndsAt()
    {
        return $this->endsAt;
    }

    /**
     * @return bool
     */
    public function getEndsOnSameDay()
    {
        return ($this->beginsAt->format('Y-m-d') == $this->endsAt->format('Y-m-d'));
    }

    /**
     * @return bool
     */
    public function getIsInThePast()
    {
        $today = new \DateTime;
        return ($this->endsAt->format('Y-m-d H:i') <= $today->format('Y-m-d H:i'));
    }

    /**
     * @param string $note
     * @return void
     */
    public function setNote($note)
    {
        $this->note = $note;
    }

    /**
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
}
