<?php
namespace Newland\Toubiz\Events\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Events\Neos\Domain\Model\Event;
use Neos\Flow\Annotations as Flow;

/**
 * An event category.
 *
 * @Flow\Entity
 */
class Category extends AbstractEntity
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Events\Neos\Domain\Model\Event", mappedBy="categories", fetch="LAZY")
     * @var Collection<Event>
     */
    protected $events;

    /**
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
}
