<?php
namespace Newland\Toubiz\Events\Neos\Controller;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Neos\Neos\Service\LinkingService;

/**
 * Abstract action controller.
 *
 * Abstract action controller for this package's controllers.
 *
 * @Flow\Scope("singleton")
 */
abstract class AbstractActionController extends ActionController
{
    /**
     * The current document node (page node).
     *
     * @var \Neos\ContentRepository\Domain\Model\Node
     */
    protected $documentNode;

    /**
     * The current node (mostly the plugin).
     *
     * @var \Neos\ContentRepository\Domain\Model\Node
     */
    protected $node;

    /**
     * @Flow\Inject
     * @var LinkingService
     */
    protected $linkingService;

    /**
     * @var array
     */
    protected $properties = [];

    /**
     * Action initializer.
     *
     * @return void
     */
    public function initializeAction()
    {
        $this->documentNode = $this->request->getInternalArgument('__documentNode');
        $this->node = $this->request->getInternalArgument('__node');

        if ($this->node->getProperties()) {
            $this->properties = $this->node->getProperties();
        }
    }

    /**
     * View initializer.
     *
     * @return void
     */
    public function initializeView(ViewInterface $view)
    {
        $view->assignMultiple([
            'documentNode' => $this->documentNode,
            'node' => $this->node
        ]);
    }
}
