<?php
namespace Newland\Toubiz\Events\Neos\Command;

/*
 * This file is part of the "toubiz-events-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cli\CommandController;
use Newland\Toubiz\Api\Repository\EventRepository as ApiEventRepository;
use Newland\Toubiz\Api\Service\ServiceFactory as ApiServiceFactory;
use Newland\Toubiz\Events\Neos\Importer\EventImporter;


/**
 * Events command controller.
 *
 * Provides commands to manipulate events data.
 *
 * @Flow\Scope("singleton")
 */
class EventsCommandController extends CommandController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Synchronize command.
     *
     * Updates local events database from API data source.
     *
     * @todo delete persisted events not being in the API response
     * @return void
     */
    public function synchronizeCommand()
    {
        $apiService = ApiServiceFactory::get('legacy');
        $apiService->setClientName($this->configuration['client']);
        $apiService->setApiKey($this->configuration['apiKey']);
        $apiService->setOrganizerId($this->configuration['organizer']);

        $apiEventRepository = new ApiEventRepository($apiService);
        $eventList = $apiEventRepository->findAllActiveEvents();

        if (!$eventList) {
            throw new \Exception('No event data received for synchronizing!');
        }

        foreach ($eventList as $listItem) {
            $importer = new EventImporter;

            if ($importer->shouldBeImported($listItem)) {
                $eventDetail = $apiEventRepository->findEvent($listItem->getExternalId());
                $importer->import($eventDetail);
            }
        }
    }
}
