<?php declare(strict_types=1);

namespace Newland\Toubiz\Common\Neos\Translation;

use Doctrine\Common\Annotations\Annotation;
use Doctrine\Common\Annotations\Annotation\Target as AnnotationTarget;

/**
 * Annotation that can be added to methods in order to mark the fact that they
 * translate node properties.
 *
 * `nodeTypes` must be set, whereas `sourceLanguages` and `targetLanguages` can be
 * left empty to listen for all translations.
 *
 * @Annotation()
 * @AnnotationTarget("METHOD")
 */
final class TranslatesNodeProperties
{
    /** @var string[] */
    public $nodeTypes = [];

    /** @var string[] */
    public $sourceLanguages;

    /** @var string[] */
    public $targetLanguages;
}
