const path = require('path');
const CleanWebpackPlugin = require('clean-webpack-plugin');
const VueLoaderPlugin = require('vue-loader/lib/plugin');

module.exports = {
    mode: 'development',

    entry: {
        index: './Resources/Private/Scripts/index.js'
    },

    output: {
        path: path.resolve(__dirname, 'Resources/Public/Scripts'),
        filename: '[name].bundle.js',
        chunkFilename: '[chunkhash].chunk.js',
        publicPath: '/_Resources/Static/Packages/Newland.Toubiz.Brochures.Neos/Scripts/',
    },

    module: {
        rules: [
            {
                test: /.jsx?$/,
                exclude: /node_modules/,
                loader: 'babel-loader',
            },
            {
                test: /\.vue$/,
                loader: 'vue-loader',
            },
        ]
    },

    plugins: [
        new CleanWebpackPlugin(),
        new VueLoaderPlugin(),
    ],

    resolve: {
        extensions: [ '.wasm', '.mjs', '.js', '.json', '.vue' ],
        alias: {
            // use minified angular instead of full version
            // angular: path.resolve(__dirname, 'node_modules/angular/angular.min.js')
            'vue$': 'vue/dist/vue.esm.js' //
        }
    }
};
