import Vue from 'vue';
import config from '../config';
import BrochureList from './components/brochure-list.vue';
import OrderForm from '../../Scripts/brochures-form/components/order-form';
import OrderStatus from '../../Scripts/brochures-form/components/order-status';
// Only for vue devtools
// TODO remove
window.Vue = Vue;

Vue.mixin({
    methods: {
        $t(label) {
            if (!window._toubizBrochuresLabels) {
                return label;
            }

            return window._toubizBrochuresLabels[label] || label;
        }
    }
});

new Vue({
    el: document.querySelector(config.brochuresFormAppSelector),

    data: {
        filterConfiguration: {
            categories: [],
            sources: [],
            targets: [],
            termsOfService: '',
        },
        activeFilters: {
            categories: [],
            sources: [],
            targets: [],
        },

        allBrochures: [],
        filteredBrochures: [],

        loading: true,
        order: {
            salutation: null,
            firstName: '',
            lastName: '',
            zip: '',
            city: '',
            street: '',
            streetNumber: '',
            country: 'de',
            eMail: '',
            brochures: [],
            language: 'de',
        },
        node: '',
        layout: '',
        showForm: false,
        statusModal: false,
        statusResult: {},
    },

    components: { BrochureList, OrderForm, OrderStatus },

    mounted () {
        this.node = this.$el.getAttribute('data-node');
        this.layout = this.$el.getAttribute('data-layout');
        this.fetchBrochuresFromApi();
        this.restoreOrderFromLocalStorage();
        console.log(JSON.parse(JSON.stringify(this.order)));
    },

    methods: {
        restoreOrderFromLocalStorage () {
            const lastFormJson = window.localStorage.getItem(config.localStorageForm);
            if (!lastFormJson) {
                return;
            }

            try {
                const data = JSON.parse(lastFormJson);
                for (let key of Object.keys(data)) {
                    this.$set(this.order, key, data[ key ]);
                }
            } catch (e) {
                console.error(e);
                window.localStorage.removeItem(config.localStorageForm);
            }
        },

        fetchBrochuresFromApi () {
            this.loading = true;
            fetch(
                `/brochures/list/${encodeURIComponent(this.node)}`,
                {
                    credentials: 'same-origin',
                },
            )
                .then(response => response.json())
                .then(data => {
                    this.allBrochures = data.brochures;
                    this.filterConfiguration = data.filter;
                    this.applyFilters();
                    this.loading = false;
                });
        },

        applyFilters () {
            // TODO this whole block does not look nice
            // TODO This filter logic needs some more thought
            this.filteredBrochures = this.allBrochures.filter(brochure => {

                if (this.activeFilters.categories && this.activeFilters.categories.length > 0) {
                    if (brochure.categories.length === 0) {
                        return false;
                    }
                    for (const category of brochure.categories) {
                        if (this.activeFilters.categories.indexOf(category.externalId) === -1) {
                            return false;
                        }
                    }
                }

                if (this.activeFilters.targets && this.activeFilters.targets.length > 0) {
                    if (brochure.targets.length === 0) {
                        return false;
                    }
                    for (const target of brochure.targets) {
                        if (this.activeFilters.targets.indexOf(target.externalId) === -1) {
                            return false;
                        }
                    }
                }

                return true;
            });
        },

        closeForm (result) {
            console.log('order close');
            console.log(result);
            this.showForm = false;
            this.openModal(result);
        },
        openModal (result) {
            console.log('emit correct, opening');
            this.statusModal = true;
            this.statusResult = result;
        }
    },

    watch: {
        order: {
            handler (order) {
                window.localStorage.toubizBrochureOrderForm = JSON.stringify(order);
            },
            deep: true,
        },
        activeFilters: {
            handler: 'applyFilters',
            deep: true,
        }
    },
});
