<?php
namespace Newland\Toubiz\Brochures\Neos\Service;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;

class ClientService
{
    /**
     * @var array
     * @Flow\InjectConfiguration(path="clients")
     */
    protected $configuration;

    public function getClient(string $currentSite)
    {
        $client = $this->configuration['default'];
        if (isset($this->configuration['sites'])
            && is_array($this->configuration['sites'])
            && array_key_exists($currentSite, $this->configuration['sites'])) {
            $client = $this->configuration['sites'][$currentSite];
        }

        return $client;
    }
}
