<?php
namespace Newland\Toubiz\Brochures\Neos\Controller;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Newland\Toubiz\Brochures\Neos\Service\ClientService;
use Newland\Toubiz\Sync\Neos\Domain\Model\BrochureOrder;

class AppController extends ActionController
{
    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;

    /**
     * @var array
     * @Flow\InjectConfiguration
     */
    protected $configuration;

    public function indexAction()
    {
        $order = new BrochureOrder();

        $this->view->assignMultiple(
            [
                'order' => $order,
                'layout' => $this->configuration['layout'],
                'node' => $this->request->getInternalArgument('__node'),
            ]
        );
    }
}
