<?php
namespace Newland\Toubiz\Brochures\Neos\Controller;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Configuration\Exception\InvalidConfigurationException;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\JsonView;
use Neos\Neos\Domain\Model\Site;
use Newland\NeosCommon\Service\NodeService;
use Newland\Toubiz\Brochures\Neos\Service\ClientService;
use Newland\Toubiz\Sync\Neos\Domain\Model\BrochureOrder;
use Newland\Toubiz\Sync\Neos\Service\BrochureOrderService;
use Neos\Flow\Annotations as Flow;

class AjaxOrderController extends ActionController
{
    protected $defaultViewObjectName = JsonView::class;

    /**
     * @var BrochureOrderService
     * @Flow\Inject()
     */
    protected $orderService;

    /**
     * @var NodeService
     * @Flow\Inject
     */
    protected $nodeService;

    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;

    /**
     * @param Node $node
     * @param array $order
     */
    public function storeAction(Node $node, array $order)
    {
        try {
            $currentSite = $this->nodeService->getCurrentSite($node);
            $client = $this->clientService->getClient($currentSite);
            $baseUrl = $this->getBaseUrl($currentSite);
            $response = $this->orderService->createOrder($client, $baseUrl, BrochureOrder::fromArray($order));
            $this->response->withStatus(($response['success'] ?? false) ? 200 : 500);
            $this->view->assign('value', $response);
        } catch (\Throwable $throwable) {
            $code = $throwable->getCode();
            if ($code >= 500 && $code <= 599) {
                $this->response->withStatus($code);
            } else {
                $this->response->withStatus(500);
            }

            $this->view->assign(
                'value',
                [
                    'error' => true,
                    'code' => $throwable->getCode(),
                    'message' => $throwable->getMessage(),
                    'file' => sprintf('%s:%s', $throwable->getFile(), $throwable->getLine()),
                    'trace' => $throwable->getTraceAsString(),
                ]
            );
        }
    }

    private function getBaseUrl(Site $currentSite): string
    {
        $domain = $currentSite->getPrimaryDomain();

        if ($domain === null) {
            throw new InvalidConfigurationException(
                'No primary domain could be found. Check the site configuration.',
                1554714084
            );
        }

        return $domain->getScheme() . '://' . $domain->getHostname();
    }
}
