<?php
namespace Newland\Toubiz\Brochures\Neos\Controller;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Newland\NeosCommon\Exceptions\UnknownSiteException;
use Newland\NeosCommon\Service\NodeService;
use Newland\Toubiz\Brochures\Neos\Service\BrochureService;
use Newland\Toubiz\Brochures\Neos\Service\ClientService;

class AjaxBrochureController extends ActionController
{
    /**
     * @var BrochureService
     * @Flow\Inject
     */
    protected $brochureService;

    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;

    /**
     * @var NodeService
     * @Flow\Inject
     */
    protected $nodeService;

    public function listAction(Node $node)
    {
        $this->response->withHeader('Content-Type', 'application/json');
        try {
            $currentSite = $this->nodeService->getCurrentSite($node);
        } catch (UnknownSiteException $e) {
            return json_encode(
                [
                    'success' => false,
                    'message' => $e->getMessage(),

                ]
            );
        }

        $client = $this->clientService->getClient($currentSite);

        return $this->brochureService->getJsonData($client);
    }
}
